<?php
include 'conexao.php';

$aluno_id = $_GET['aluno_id'] ?? null;

if (!$aluno_id) {
    echo "<script>alert('Aluno não definido.'); window.location.href='preencher_termo.php';</script>";
    exit;
}

// Dados do aluno
$stmt = $conn->prepare("SELECT * FROM alunos WHERE id = ?");
$stmt->bind_param("i", $aluno_id);
$stmt->execute();
$aluno = $stmt->get_result()->fetch_assoc();

// Dados do termo
$stmt = $conn->prepare("SELECT * FROM termos WHERE aluno_id = ?");
$stmt->bind_param("i", $aluno_id);
$stmt->execute();
$termo = $stmt->get_result()->fetch_assoc();

// Notas por disciplina
$notas = [];
$stmt = $conn->prepare("SELECT * FROM notas_termos_anteriores WHERE aluno_id = ?");
$stmt->bind_param("i", $aluno_id);
$stmt->execute();
$result = $stmt->get_result();
while ($row = $result->fetch_assoc()) {
    $notas[] = $row;
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Termo Completo</title>
  <style>
    body {
      font-family: 'Times New Roman', serif;
      background: white;
      padding: 40px;
    }
    .cabecalho {
      text-align: center;
      margin-bottom: 30px;
    }
    .cabecalho img {
      width: 80px;
      float: left;
    }
    .cabecalho h1 {
      font-size: 20px;
      text-transform: uppercase;
      margin: 0;
    }
    .cabecalho h2 {
      font-size: 16px;
      margin-top: 5px;
    }
    hr {
      border: 1px solid #333;
      margin-top: 40px;
    }
    .bloco {
      margin-bottom: 25px;
    }
    .label {
      font-weight: bold;
      width: 180px;
      display: inline-block;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      font-size: 14px;
    }
    th, td {
      border: 1px solid #999;
      padding: 6px;
      text-align: center;
    }
    .assinatura {
      margin-top: 40px;
      display: flex;
      justify-content: space-between;
    }
    .assinatura div {
      text-align: center;
      width: 30%;
    }
    .btn-print {
      background: #003366;
      color: white;
      padding: 10px 20px;
      border: none;
      border-radius: 5px;
      margin-bottom: 30px;
      cursor: pointer;
    }
    @media print {
      .btn-print { display: none; }
    }
  </style>
</head>
<body>

<button class="btn-print" onclick="window.print()">🖨️ Imprimir Termo</button>

<div class="cabecalho">
  <img src="logo.png" alt="Logo Escola">
  <h1>REPÚBLICA DE ANGOLA</h1>
  <h2>Ministério da Educação</h2>
  <h2>Magistério 5 de Outubro – Benguela</h2>
  <p><strong>Termo de Registo Escolar</strong></p>
</div>

<hr>

<div class="bloco">
  <p><span class="label">Nome Completo:</span> <?= htmlspecialchars($aluno['nome']) ?></p>
  <p><span class="label">Género:</span> <?= htmlspecialchars($aluno['genero']) ?></p>
  <p><span class="label">Idade:</span> <?= htmlspecialchars($aluno['idade']) ?></p>
  <p><span class="label">Turma:</span> <?= htmlspecialchars($aluno['turma'] ?? '') ?></p>
  <p><span class="label">Curso:</span> <?= htmlspecialchars($aluno['curso'] ?? '') ?></p>
</div>

<?php if ($termo): ?>
<div class="bloco">
  <p><span class="label">Número de Processo:</span> <?= htmlspecialchars($termo['numero_processo']) ?></p>
  <p><span class="label">Naturalidade:</span> <?= htmlspecialchars($termo['naturalidade']) ?></p>
  <p><span class="label">Data de Nascimento:</span> <?= htmlspecialchars($termo['data_nascimento']) ?></p>
  <p><span class="label">Nº BI:</span> <?= htmlspecialchars($termo['bi_numero']) ?></p>
  <p><span class="label">Local de Emissão do BI:</span> <?= htmlspecialchars($termo['bi_emissao_local']) ?></p>
  <p><span class="label">Data de Emissão:</span> <?= htmlspecialchars($termo['bi_emissao_data']) ?></p>
  <p><span class="label">Nome do Pai:</span> <?= htmlspecialchars($termo['pai']) ?></p>
  <p><span class="label">Nome da Mãe:</span> <?= htmlspecialchars($termo['mae']) ?></p>
  <p><span class="label">Observações:</span><br><?= nl2br(htmlspecialchars($termo['observacoes'])) ?></p>
</div>
<?php endif; ?>

<?php if (count($notas) > 0): ?>
<h3>Notas dos Termos Anteriores</h3>
<table>
  <thead>
    <tr>
      <th>Disciplina</th>
      <th>Classe</th>
      <th>Ano</th>
      <th>MT1</th>
      <th>MT2</th>
      <th>MT3</th>
      <th>MFD</th>
      <th>Exame</th>
      <th>MF</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($notas as $n): ?>
    <tr>
      <td><?= htmlspecialchars($n['disciplina']) ?></td>
      <td><?= $n['classe'] ?></td>
      <td><?= $n['ano_lectivo'] ?></td>
      <td><?= $n['mt1'] ?></td>
      <td><?= $n['mt2'] ?></td>
      <td><?= $n['mt3'] ?></td>
      <td><?= $n['mfd'] ?></td>
      <td><?= $n['exame'] ?></td>
      <td><strong><?= $n['mf'] ?></strong></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php else: ?>
<p><em>Este aluno ainda não possui notas lançadas nos termos anteriores.</em></p>
<?php endif; ?>

<div class="assinatura">
  <div>
    ___________________________<br>
    Diretor Pedagógico
  </div>
  <div>
    ___________________________<br>
    Secretário Escolar
  </div>
</div>

</body>
</html>
